/****** Object:  UserDefinedFunction [dbo].[UFD_BC_LANC_POS_FINANCEIRA]    Script Date: 10/09/2012 14:18:21 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BC_LANC_POS_FINANCEIRA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_BC_LANC_POS_FINANCEIRA]
GO  
--SELECT * FROM UFD_BC_LANC_POS_FINANCEIRA(1,'145,73,14,69,47,142,118,117,140','2009-01-01','2009-01-24')
CREATE  FUNCTION [dbo].[UFD_BC_LANC_POS_FINANCEIRA](
--CREATE FUNCTION UFD_BC_LANC_POS_FINANCEIRA(
									@CD_EMP		INT,
									@CD_CNT     VARCHAR(2000),
									@DT_INI		DATETIME,
									@DT_FIM		DATETIME)--0 No Compensado; 1 - Compensado
RETURNS @RS_RETORNO TABLE(
								CD_EMP 			INT,
								NM_GRP_ECON     VARCHAR(100),
								CD_CNT			INT,
								NR_CNT			VARCHAR(100),
								DS_BC			VARCHAR(100),
								VLR_CRED		MONEY,
								VLR_DEB			MONEY,
								VLR_DEB_TRANSF  MONEY,
								VLR_CRED_TRANSF MONEY,
								VLR_SLD			MONEY,
								VLR_LIMITE      MONEY,
								VLR_NAO_CONCILIADO MONEY)
AS
BEGIN

DECLARE @RS_BC_LANC TABLE(
								CD_EMP 			INT,
								NM_GRP_ECON     VARCHAR(100),
								CD_CNT			INT,
								NR_CNT			VARCHAR(100),
								DS_BC			VARCHAR(100),
								VLR_CRED		MONEY,
								VLR_DEB			MONEY,
								VLR_DEB_TRANSF  MONEY,
								VLR_CRED_TRANSF MONEY,
								VLR_SLD			MONEY, 
								VLR_LIMITE      MONEY,
								VLR_NAO_CONCILIADO MONEY)

--Matriz de valores e tipo de lancamento
DECLARE @RS_BC_LANC_VLR	TABLE(CD_EMP		INT,
							  CD_CNT		INT,
							  VLR_LANC	    MONEY,
							  TP_LANC		INT)
--Fim

INSERT INTO @RS_BC_LANC
	SELECT     
		BC_CONTAS.CD_EMP, 
		PRC_GRP_ECON.NM_GRP_ECON,
		BC_CONTAS.CD_CNT, 
		BC_CONTAS.NR_CNT, 
		BC_BANCO.DS_BC, 
		0, 
		0,
		0,
		0,
		ISNULL((DBO.UFD_BC_LANC_EXTRATO_SLD(BC_CONTAS.CD_EMP,BC_CONTAS.CD_CNT,@DT_INI,0)),0),
		BC_CONTAS.VLR_LIMITE,
		0
	FROM         
		BC_CONTAS 
		INNER JOIN BC_BANCO ON 
		BC_CONTAS.CD_EMP = BC_BANCO.CD_EMP AND 
		BC_CONTAS.CD_BC = BC_BANCO.CD_BC
		INNER JOIN BC_CONTAS_PRC_GRP_ECON ON
		BC_CONTAS.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
		BC_CONTAS.CD_CNT = BC_CONTAS_PRC_GRP_ECON.CD_CNT 
		INNER JOIN PRC_GRP_ECON ON
		BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON = PRC_GRP_ECON.CD_GRP_ECON		
	WHERE   
		BC_CONTAS.CD_EMP= @CD_EMP  
		AND BC_CONTAS.CD_CNT IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_CNT))	
		AND BC_CONTAS.STS_CNT = 0

INSERT INTO @RS_BC_LANC_VLR
	SELECT     
		BC_LANC.CD_EMP, 
		BC_LANC.CD_CNT, 
		SUM(BC_LANC.VLR_LANC) AS VLR_LANC,
		BC_LANC.TP_LANC
	FROM         
		BC_LANC 
	WHERE     
		BC_LANC.CD_EMP= @CD_EMP
		AND BC_LANC.DT_LANCTO BETWEEN @DT_INI AND @DT_FIM
		AND NOT EXISTS(SELECT 
						   CD_EMP 
					   FROM 
						   BC_LANC_TRANSF orig
						WHERE
							BC_LANC.CD_EMP = orig.CD_EMP AND
							BC_LANC.CD_BC_LANC = orig.CD_BC_LANC_ORIG)
		AND NOT EXISTS(SELECT 
						   CD_EMP 
					   FROM 
						   BC_LANC_TRANSF dest
						WHERE
							BC_LANC.CD_EMP = dest.CD_EMP AND
							BC_LANC.CD_BC_LANC = dest.CD_BC_LANC_DEST)
	GROUP BY 
		BC_LANC.CD_EMP, 
		BC_LANC.CD_CNT, 
		BC_LANC.TP_LANC
UNION ALL
	SELECT     
		BC_LANC.CD_EMP, 
		orig.CD_CNT_ORIG, 
		SUM(BC_LANC.VLR_LANC) AS VLR_LANC,
		3
	FROM         
		BC_LANC INNER JOIN BC_LANC_TRANSF orig ON
		BC_LANC.CD_EMP = orig.CD_EMP AND
		BC_LANC.CD_BC_LANC = orig.CD_BC_LANC_ORIG 		
	WHERE     
		BC_LANC.CD_EMP= @CD_EMP
		AND BC_LANC.DT_LANCTO BETWEEN @DT_INI AND @DT_FIM
	GROUP BY 
		BC_LANC.CD_EMP, 
		orig.CD_CNT_ORIG, 
		BC_LANC.TP_LANC
UNION ALL
	SELECT     
		BC_LANC.CD_EMP, 
		dest.CD_CNT_DEST, 
		SUM(BC_LANC.VLR_LANC) AS VLR_LANC,
		4
	FROM         
		BC_LANC INNER JOIN BC_LANC_TRANSF dest ON
		BC_LANC.CD_EMP = dest.CD_EMP AND
		BC_LANC.CD_BC_LANC = dest.CD_BC_LANC_DEST 		
	WHERE     
		BC_LANC.CD_EMP= @CD_EMP
		AND BC_LANC.DT_LANCTO BETWEEN @DT_INI AND @DT_FIM
	GROUP BY 
		BC_LANC.CD_EMP, 
		dest.CD_CNT_DEST, 
		BC_LANC.TP_LANC

--Gerando crditos
UPDATE 
	@RS_BC_LANC 
SET 
	VLR_CRED = RS_BC_LANC_VLR.VLR_LANC
FROM 
	@RS_BC_LANC RS_BC_LANC,
	@RS_BC_LANC_VLR RS_BC_LANC_VLR
WHERE 
	RS_BC_LANC_VLR.CD_EMP = RS_BC_LANC.CD_EMP AND
	RS_BC_LANC_VLR.CD_CNT = RS_BC_LANC.CD_CNT AND 
	RS_BC_LANC_VLR.TP_LANC = 0
--Fim

--Gerando crditos por transferncia
UPDATE 
	@RS_BC_LANC 
SET 
	VLR_CRED_TRANSF =  RS_BC_LANC_VLR.VLR_LANC
FROM 
	@RS_BC_LANC RS_BC_LANC,
	@RS_BC_LANC_VLR RS_BC_LANC_VLR
WHERE 
	RS_BC_LANC_VLR.CD_EMP = RS_BC_LANC.CD_EMP AND
	RS_BC_LANC_VLR.CD_CNT = RS_BC_LANC.CD_CNT AND 
	RS_BC_LANC_VLR.TP_LANC = 4
--Fim

--Gerando Dbitos	
UPDATE 
	@RS_BC_LANC
SET 
	VLR_DEB = RS_BC_LANC_VLR.VLR_LANC
FROM 
	@RS_BC_LANC RS_BC_LANC,
	@RS_BC_LANC_VLR RS_BC_LANC_VLR
WHERE 
	RS_BC_LANC_VLR.CD_EMP = RS_BC_LANC.CD_EMP AND
	RS_BC_LANC_VLR.CD_CNT = RS_BC_LANC.CD_CNT AND 
	RS_BC_LANC_VLR.TP_LANC = 1
--Fim

--Gerando Dbitos por transferencia
UPDATE 
	@RS_BC_LANC
SET 
	VLR_DEB_TRANSF =  RS_BC_LANC_VLR.VLR_LANC
FROM 
	@RS_BC_LANC RS_BC_LANC,
	@RS_BC_LANC_VLR RS_BC_LANC_VLR
WHERE 
	RS_BC_LANC_VLR.CD_EMP = RS_BC_LANC.CD_EMP AND
	RS_BC_LANC_VLR.CD_CNT = RS_BC_LANC.CD_CNT AND 
	RS_BC_LANC_VLR.TP_LANC = 3
--Fim

DECLARE @RSBANCCOMPESADO TABLE (CD_CNT INT, VLR_LANC MONEY)

INSERT INTO @RSBANCCOMPESADO
SELECT
	BC_LANC.CD_CNT,
	ISNULL(SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN VLR_LANC ELSE -VLR_LANC END),0) AS VLR_LANC
FROM
	BC_LANC INNER JOIN GLB_DOC ON
	BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
	BC_LANC.CD_DOC = GLB_DOC.CD_DOC
WHERE
	BC_LANC.CD_EMP = @CD_EMP
	AND BC_LANC.CD_CNT IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_CNT))
	AND BC_LANC.DT_LANCTO <= @DT_FIM
	AND NOT EXISTS (
					SELECT
						CD_BC_LANC
					FROM
						BC_LANC_CONC
					WHERE
						BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
						BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND 
						BC_LANC_CONC.DT_COMPES <= @DT_FIM)
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								V_BC_CHQ_LANC_COMPENSADO
							WHERE
								V_BC_CHQ_LANC_COMPENSADO.CD_EMP		= BC_LANC.CD_EMP AND
								V_BC_CHQ_LANC_COMPENSADO.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
								V_BC_CHQ_LANC_COMPENSADO.CD_CNT		= BC_LANC.CD_CNT AND
								V_BC_CHQ_LANC_COMPENSADO.DT_COMPES <= @DT_FIM)
			GROUP BY
				BC_LANC.CD_CNT

--Gerando Dbitos por transferencia
UPDATE 
	RS_BC_LANC
SET 
	VLR_NAO_CONCILIADO =  P.VLR_LANC
FROM 
	@RS_BC_LANC RS_BC_LANC INNER JOIN @RSBANCCOMPESADO p ON
	RS_BC_LANC.CD_CNT = p.CD_CNT
--Fim

INSERT INTO @RS_RETORNO SELECT * FROM  @RS_BC_LANC 
RETURN
END